/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import cpw.mods.fml.client.FMLClientHandler;
import jds.bibliocraft.BiblioRenderHelper;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.models.ModelGenericShelf;
import jds.bibliocraft.models.OBJShelf;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemGenericShelfRenderer
implements IItemRenderer {
    private ModelGenericShelf shelfModel;
    private OBJShelf objModel = new OBJShelf();
    private static boolean useTextureSheet;

    public ItemGenericShelfRenderer() {
        this.shelfModel = new ModelGenericShelf();
        useTextureSheet = this.usesTextureSheet();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int metaTest = item.func_77960_j();
        String textureLoc = "none";
        NBTTagCompound tags = item.func_77978_p();
        if (tags != null && tags.func_74764_b("renderTexture")) {
            textureLoc = tags.func_74779_i("renderTexture");
        }
        switch (type) {
            case ENTITY: {
                this.renderGenericShelf(-0.25f, 0.47f, 0.0f, metaTest, true, textureLoc);
                break;
            }
            case EQUIPPED: {
                this.renderGenericShelf(0.6f, 1.0f, 0.8f, metaTest, false, textureLoc);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderGenericShelf(0.6f, 1.0f, 0.8f, metaTest, false, textureLoc);
                break;
            }
            case INVENTORY: {
                this.renderGenericShelf(1.25f, 1.6f, 1.0f, metaTest, false, textureLoc);
                break;
            }
        }
    }

    private void renderGenericShelf(float i, float j, float k, int metaData, boolean entity, String texLoc) {
        float scale = 0.0625f;
        Tessellator tesselator = Tessellator.field_78398_a;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getModelTexture(metaData));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)i, (float)j, (float)k);
        if (entity) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (useTextureSheet && metaData != 6) {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getModelTexture(metaData));
            this.shelfModel.renderShelf(scale);
            this.shelfModel.renderTop(scale);
        } else {
            if (texLoc.contentEquals("none")) {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getVanillaWoodTexture(metaData));
            } else {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(BiblioRenderHelper.getBlockResource(texLoc));
            }
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            this.objModel.render();
            this.objModel.renderTop();
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glPopMatrix();
    }

    public ResourceLocation getModelTexture(int metadata) {
        switch (metadata) {
            case 0: {
                return CommonProxy.GENERICSHELF0_PNG;
            }
            case 1: {
                return CommonProxy.GENERICSHELF1_PNG;
            }
            case 2: {
                return CommonProxy.GENERICSHELF2_PNG;
            }
            case 3: {
                return CommonProxy.GENERICSHELF3_PNG;
            }
            case 4: {
                return CommonProxy.GENERICSHELF4_PNG;
            }
            case 5: {
                return CommonProxy.GENERICSHELF5_PNG;
            }
        }
        return CommonProxy.GENERICSHELF0_PNG;
    }

    public ResourceLocation getVanillaWoodTexture(int meta) {
        switch (meta) {
            case 0: {
                return CommonProxy.PLANKSOAK;
            }
            case 1: {
                return CommonProxy.PLANKSSPRUCE;
            }
            case 2: {
                return CommonProxy.PLANKSBIRCH;
            }
            case 3: {
                return CommonProxy.PLANKSJUNGLE;
            }
            case 4: {
                return CommonProxy.PLANKSACACIA;
            }
            case 5: {
                return CommonProxy.PLANKSOLDOAK;
            }
            case 6: {
                return CommonProxy.FRAME_BLOCK;
            }
        }
        return CommonProxy.PLANKSOAK;
    }

    public boolean usesTextureSheet() {
        return Config.useTextureSheet;
    }
}

